﻿<%@ Page Language="C#" MasterPageFile="~/TBI_Instruments/RegistryInstrument.master" AutoEventWireup="true" CodeFile="VALowVisionSurvey.aspx.cs"
    Inherits="TBI_Instruments_VALowVisionSurvey" Title="" %>

<%@ Import Namespace="VeteransAffairs.Registries.Business" %>

<%@ Register TagPrefix="VA" TagName="TbiDiagnosisSelector" Src="~/controls/TbiDiagnosisSelector.ascx" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="ajaxToolkit" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="Server">
    <link type="text/css" href="~/styles/StyleSheet.css" />
    <style type="text/css">
        .breadcrumbInstrument
        {
            background-color: #6B1424;
            border-bottom: 1px solid #000;
            color: #FFF;
            font-family: Verdana, Geneva, Arial, Helvetica, sans-serif;
            font-variant: small-caps;
            font-weight: 700;
            letter-spacing: 1px;
            margin: 2px 0 2px 0;
            padding: 8px 25px 5px 10px;
        }
        .detailTable
        {
            border: 0px;
            background-color: #FFFFFF;
        }
        .detailTable td
        {
            border: 0px;
            background-color: #FFFFFF;
        }
        .requiredField
        {
            font-weight: bold;
            color: #FF0000;
        }
    </style>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" runat="Server">
    <asp:ScriptManager ID="ScriptManager1" runat="server">
    </asp:ScriptManager>
    
    <script type="text/javascript">
        Sys.WebForms.PageRequestManager.getInstance().add_beginRequest(startRequest);
        Sys.WebForms.PageRequestManager.getInstance().add_endRequest(endRequest);

        var tmr = null;

        function getTimerReference() {
            if (tmr == null) {
                tmr = $find("<%= InactiveTimer.ClientID %>");
            }
            return tmr;
        }

        function StopTimer() {
            // alert('stop');
            getTimerReference()._stopTimer();
        }

        function StartTimer() {
            //alert('start');
            getTimerReference()._startTimer();
        }

        function startRequest(sender, e) {
            StartTimer();
            //disable buttons during the AJAX call
            document.getElementById('<%=btnSaveSurveyDraft.ClientID%>').disabled = true;
            document.getElementById('<%=btnSubmitSurvey.ClientID%>').disabled = true;
            document.getElementById('<%=btnCancelSurvey.ClientID%>').disabled = true;
        }

        function endRequest(sender, e) {
            //re-enable buttons once the AJAX call has completed
            document.getElementById('<%=btnSaveSurveyDraft.ClientID%>').disabled = false;
            document.getElementById('<%=btnSubmitSurvey.ClientID%>').disabled = false;
            document.getElementById('<%=btnCancelSurvey.ClientID%>').disabled = false;
        }
    </script>

    <telerik:RadCodeBlock runat="server" ID="RadCodeBlock1">

        <script type="text/javascript">
            $(document).ready(function () {
                //Disables 'Enter' Key from posting back on any input element ( textbox, radiolist, checkbox, etc )
                //also resets inactive timer
                $('input').keydown(function (e) {
                    StopTimer();
                    StartTimer();
                });

                //Disables 'Enter' Key from posting back when no input element is in focus, and the enter key is presssed
                //also resets inactive timer
                $('div').keydown(function (e) {
                    StopTimer();
                    StartTimer();
                });

                //resets inactive timer on click of a radio element
                $('input[type=radio]').click(function (e) {
                    StopTimer();
                    StartTimer();
                });

                //resets inactive timer on click of a checkbox element
                $('input[type=checkbox]').click(function (e) {
                    StopTimer();
                    StartTimer();
                });

                window.onbeforeunload = function (e) {
                    //Save draft if timeout occurs
                    document.getElementById('<%= btnSaveSurveyDraft.ClientID %>').click();
                }
            }); // END $(document).ready(function()

            function clearRadioButtonListSelection(listName) 
            {
                var rbList = document.getElementById(listName);
                var radio = rbList.getElementsByTagName("input");

                var currIndex = GetListIndexSelected(listName);
                if (currIndex > -1) {
                    radio[currIndex].checked = false;
                }
            }

            function GetListIndexSelected(listName) {
                var rbList = document.getElementById(listName);
                var radio = rbList.getElementsByTagName("input");
                var ret = -1;

                for (var i = 0; i < radio.length; i++) {
                    if (radio[i].checked) {
                        ret = i;
                        break;
                    }
                }
                return ret;
            } 

            function GetLastElementIndex(listName) {
                var rbList = document.getElementById(listName);
                var radio = rbList.getElementsByTagName("input");
                var ret = -1;

                ret = radio.length - 1;

                return ret;
            }

            function btnSaveButtonChange_Click() {
                //Save draft if question 8,15,16V,28 is changed occurs
                //document.getElementById('<%= btnSaveSurveyDraft.ClientID %>').click();
                //alert("Auto-Saving");
            }

        </script>

    </telerik:RadCodeBlock>
    <telerik:RadCodeBlock runat="server" ID="RadCodeBlock2">
        <div class="breadcrumbInstrument">
            <asp:Label ID="LabelBreadCrumb" runat="server" Text="TBI Instruments > Instrument Associations > VA Low Vision Visual Functioning (VA LV VFQ 20) Survey"></asp:Label>
        </div>
    </telerik:RadCodeBlock>
    <telerik:RadCodeBlock runat="server" ID="RadCodeBlock3">
        <asp:UpdatePanel ID="MainUpdatePanel" runat="server">
            <ContentTemplate>
                <asp:UpdateProgress ID="MainUpdateProgress" runat="server">
                    <ProgressTemplate>
                        <!-- Modal Popup for Loading -->
                        <div style="padding-left: 3px;">
                            <div style="background-color: #FF0000; width: 170px; color: #FFFFFF; padding: 5px;">
                                Processing...Please wait.
                            </div>
                        </div>
                        <%--<div style="background-color: Gray; filter: alpha(opacity=50); opacity: 0.50; width: 100%; top: 0px; left: 0px; position: fixed;
                            height: 100%;">
                        </div>
                        <div style="margin: auto; font-family: Trebuchet MS; filter: alpha(opacity=100); opacity: 1; font-size: small; vertical-align: middle;
                            top: 45%; position: fixed; right: 45%; color: #232323; text-align: center; background-color: White; height: 100px;">
                            <table style="background-color: White; font-family: Sans-Serif; text-align: center; border: solid 1px #232323; color: #232323;
                                width: 300px; height: inherit; padding: 15px;">
                                <tr>
                                    <td style="text-align: inherit;">
                                        <img src="images/loading_image.gif" alt="Loading" title="Loading Image" />
                                    </td>
                                    <td style="text-align: inherit;">
                                        <span style="font-family: Sans-Serif; font-size: medium; font-weight: bold; font">Processing...Please wait.</span>
                                    </td>
                                </tr>
                            </table>
                        </div>--%>
                        <!-- End Modal Popup for Loading -->
                    </ProgressTemplate>
                </asp:UpdateProgress>
                <asp:ValidationSummary ID="TBIInstrumentsValidationSummaryOnSave" runat="server" TabIndex="1" HeaderText="The page has the following data errors:"
                    DisplayMode="BulletList" ShowSummary="false" ShowMessageBox="true" ValidationGroup="OnSave" />
                <asp:Panel ID="PanelPatient" Width="100%" GroupingText="&nbsp;&nbsp;Patient&nbsp;&nbsp;" runat="server">
                    <table cellpadding="5" cellspacing="5">
                        <tr>
                            <td>
                                &nbsp;&nbsp;<asp:Label ID="LabelForName" runat="server" Text="Patient:" AssociatedControlID="LabelPatient"></asp:Label>&nbsp;<asp:Label
                                    ID="LabelPatient" runat="server" SkinID="DataLabel" TabIndex="2"></asp:Label>
                            </td>
                            <td>
                                <asp:Label ID="LabelForSSN" runat="server" SkinID="DataLabel" AssociatedControlID="LabelSSN" Text="SSN:"></asp:Label>
                                &nbsp;<asp:Label ID="LabelSSN" runat="server" SkinID="DataLabel" TabIndex="3"></asp:Label>
                            </td>
                            <td>
                                <asp:Label ID="LabelForFacility" runat="server" SkinID="DataLabel" AssociatedControlID="LabelFacility" Text="Facility:" Visible="false"></asp:Label>
                                &nbsp;<asp:Label ID="LabelFacility" runat="server" SkinID="DataLabel" TabIndex="4"></asp:Label>
                            </td>
                        </tr>
                    </table>
                </asp:Panel>
                <!-- Hidden Field - Survey Type -->
                <asp:HiddenField ID="HiddenSurveyType" runat="server" Visible="false" Value="VALVVFS" />
                <asp:Panel ID="PanelSurveyHeader" Width="100%" runat="server" CssClass="mainContent">
                    <br />
                    <asp:Label ID="LabelInstrumentTitle" runat="server" Style="font-weight: bold" />
                    <br />
                </asp:Panel>
                <!-- Instruction Area -->
                <asp:Panel ID="PanelInstructions" runat="server" Visible="false">
                    <br />
                    <div style="padding: 5px; width: 900px;">
                    </div>
                </asp:Panel>
                <!-- End Instruction Area -->
                <asp:Panel ID="PanelQuestions" Width="100%" runat="server" CssClass="mainContent">
                    <br />
                    <!-- Question Area -->
                    <table style="width: 800px; border: 1px solid navy;">
                        <tr>
                            <td colspan="3">
                                <strong>Select one of the responses listed below to indicate level of difficulty for each activity which pertains the following
                                    question: Is it difficult to...?</strong><br />
                                1 = Impossible<br />
                                2 = Extremely Difficult<br />
                                3 = Slightly/Moderately Difficult<br />
                                4 = Not Difficult<br />
                                0 = Unscored - Patient not interested in activity<br />
                                <br />
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 20px;">
                            </td>
                            <td style="text-align: left; padding: 5px;">
                                <!--Date-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelDate1" runat="server" AssociatedControlID="dpDate1" SkinID="DataLabel" TabIndex="6">
                                </asp:Label>
                                <span class="requiredField">*</span>
                            </td>
                            <td style="text-align: left; padding: 5px;">
                                <!--Date picker-->
                                <telerik:RadDatePicker ID="dpDate1" runat="server" TabIndex="7">
                                    <Calendar ID="calDate1" runat="server">
                                    </Calendar>
                                </telerik:RadDatePicker>
                                <!--Date 1 required field validator (only one required)-->
                                <br />
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorDate1" runat="server" ControlToValidate="dpDate1" TabIndex="8" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Date is required."></asp:RequiredFieldValidator>
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 20px;">
                            </td>
                            <td colspan="2" style="text-align: left; padding: 5px;">
                                <!-- Diagnosis Control -->
                                <!-- Set Question Text, SurveyTypeId, SurveyTypeCode in the page_load -->
                                <VA:TbiDiagnosisSelector ID="ctrlDiagnosis" runat="server" QuestionNumber="DX" StartTabIndex="10" />
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 20px;">
                            </td>
                            <td style="text-align: left; padding: 5px;">
                                <!--Question TYP: Type of Submission-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForTYP" runat="server" AssociatedControlID="rblQTYP" SkinID="DataLabel" TabIndex="17">
                                </asp:Label>
                                <span class="requiredField">*</span>
                            </td>
                            <td style="text-align: left; padding: 5px;">
                                <!-- Question TYP: Baseline / Follow-Up Choice List-->
                                <asp:RadioButtonList ID="rblQTYP" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQTYP" TabIndex="18" OnDataBound="rblQTYP_DataBound" 
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="true" OnSelectedIndexChanged="rblQTYP_SelectedIndexChanged">
                                </asp:RadioButtonList>
                                <!--Question TYP Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQTYP" runat="server" ControlToValidate="rblQTYP" TabIndex="19" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <!--Question TYP Object Data Source-->
                                <asp:ObjectDataSource ID="ObjectDataSourceQTYP" runat="server" 
                                    SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQTYP" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <!--Question TYP : Question Number-->
                                <asp:HiddenField ID="HiddenQTYP" runat="server" Visible="false" Value="TYP" />
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 20px; padding: 5px;">
                            </td>
                            <td style="text-align: left; padding: 5px;">
                                <!--Question 1: BRS Program Type:-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ1" runat="server" AssociatedControlID="rblQ1" SkinID="DataLabel" TabIndex="20">
                                </asp:Label>
                                <span class="requiredField">*</span>
                            </td>
                            <td style="text-align: left; padding: 5px;">
                                <!-- Q1 - BRS Program Type -->
                                <asp:RadioButtonList ID="rblQ1" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ1" TabIndex="21"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <!--Question 1 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ1" runat="server" ControlToValidate="rblQ1" TabIndex="22" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <!--Question 1 Object Data Source-->
                                <asp:ObjectDataSource ID="ObjectDataSourceQ1" runat="server" 
                                    SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ1" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <!--Question 1 : Question Number-->
                                <asp:HiddenField ID="HiddenQ1" runat="server" Visible="false" Value="1" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%" style="text-align: left; font-size: 1px; height: 5px;">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2" style="text-align: left;">
                                <b>Activity</b>
                            </td>
                            <td style="text-align: left;">
                                <b>Level of Difficulty</b>
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 20px;">
                                1.
                            </td>
                            <td style="text-align: left;">
                                <!--Question 2: Read newspapers or magazine articles:-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ2" runat="server" AssociatedControlID="rblQ2" SkinID="DataLabel" TabIndex="23">
                                </asp:Label>
                                <span class="requiredField">*</span>
                            </td>
                            <td style="text-align: left;">
                                <!-- Q2 - Read newspaper or magazine articles -->
                                <asp:RadioButtonList ID="rblQ2" runat="server" RepeatDirection="Horizontal" Width="200px" DataSourceID="ObjectDataSourceQ2"
                                    TabIndex="24" DataTextField="CHOICE_NAME" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave"
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <!--Question 2 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ2" runat="server" ControlToValidate="rblQ2" TabIndex="25" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <!--Question 2 Object Data Source-->
                                <asp:ObjectDataSource ID="ObjectDataSourceQ2" runat="server" 
                                    SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ2" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <!--Question 2 : Question Number-->
                                <asp:HiddenField ID="HiddenQ2" runat="server" Visible="false" Value="2" />
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 20px;">
                                2.
                            </td>
                            <td style="text-align: left;">
                                <!--Question 3: Read mail:-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ3" runat="server" AssociatedControlID="rblQ3" SkinID="DataLabel" TabIndex="26">
                                </asp:Label>
                                <span class="requiredField">*</span>
                            </td>
                            <td style="text-align: left;">
                                <!-- Q3 - Read newspaper or magazine articles -->
                                <asp:RadioButtonList ID="rblQ3" runat="server" RepeatDirection="Horizontal" Width="200px" DataSourceID="ObjectDataSourceQ3"
                                    TabIndex="27" DataTextField="CHOICE_NAME" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave"
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <!--Question 3 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ3" runat="server" ControlToValidate="rblQ3" TabIndex="28" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <!--Question 3 Object Data Source-->
                                <asp:ObjectDataSource ID="ObjectDataSourceQ3" runat="server" 
                                    SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ3" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <!--Question 3 : Question Number-->
                                <asp:HiddenField ID="HiddenQ3" runat="server" Visible="false" Value="3" />
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 20px;">
                                3.
                            </td>
                            <td style="text-align: left;">
                                <!--Question 4: Read small print on package label-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ4" runat="server" AssociatedControlID="rblQ4" SkinID="DataLabel" TabIndex="29">
                                </asp:Label>
                                <span class="requiredField">*</span>
                            </td>
                            <td style="text-align: left;">
                                <!-- Q4 - Read newspaper or magazine articles -->
                                <asp:RadioButtonList ID="rblQ4" runat="server" RepeatDirection="Horizontal" Width="200px" DataSourceID="ObjectDataSourceQ4"
                                    TabIndex="30" DataTextField="CHOICE_NAME" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave"
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <!--Question 4 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ4" runat="server" ControlToValidate="rblQ4" TabIndex="31" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <!--Question 4 Object Data Source-->
                                <asp:ObjectDataSource ID="ObjectDataSourceQ4" runat="server" 
                                    SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ4" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <!--Question 4 : Question Number-->
                                <asp:HiddenField ID="HiddenQ4" runat="server" Visible="false" Value="4" />
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 20px;">
                                4.
                            </td>
                            <td style="text-align: left;">
                                <!--Question 5: Keep your place while reading-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ5" runat="server" AssociatedControlID="rblQ5" SkinID="DataLabel" TabIndex="32">
                                </asp:Label>
                                <span class="requiredField">*</span>
                            </td>
                            <td style="text-align: left;">
                                <!-- Q5 - Read newspaper or magazine articles -->
                                <asp:RadioButtonList ID="rblQ5" runat="server" RepeatDirection="Horizontal" Width="200px" DataSourceID="ObjectDataSourceQ5"
                                    TabIndex="33" DataTextField="CHOICE_NAME" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave"
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <!--Question 5 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ5" runat="server" ControlToValidate="rblQ5" TabIndex="34" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <!--Question 5 Object Data Source-->
                                <asp:ObjectDataSource ID="ObjectDataSourceQ5" runat="server" 
                                    SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ5" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <!--Question 5 : Question Number-->
                                <asp:HiddenField ID="HiddenQ5" runat="server" Visible="false" Value="5" />
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 20px;">
                                5.
                            </td>
                            <td style="text-align: left;">
                                <!--Question 6: Handle finances-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ6" runat="server" AssociatedControlID="rblQ6" SkinID="DataLabel" TabIndex="35">
                                </asp:Label>
                                <span class="requiredField">*</span>
                            </td>
                            <td style="text-align: left;">
                                <!-- Q6 - Read newspaper or magazine articles -->
                                <asp:RadioButtonList ID="rblQ6" runat="server" RepeatDirection="Horizontal" Width="200px" DataSourceID="ObjectDataSourceQ6"
                                    TabIndex="36" DataTextField="CHOICE_NAME" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave"
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <!--Question 6 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ6" runat="server" ControlToValidate="rblQ6" TabIndex="37" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <!--Question 6 Object Data Source-->
                                <asp:ObjectDataSource ID="ObjectDataSourceQ6" runat="server" 
                                    SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ6" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <!--Question 6 : Question Number-->
                                <asp:HiddenField ID="HiddenQ6" runat="server" Visible="false" Value="6" />
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 20px;">
                                6.
                            </td>
                            <td style="text-align: left;">
                                <!--Question 7: Take a message-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ7" runat="server" AssociatedControlID="rblQ7" SkinID="DataLabel" TabIndex="38">
                                </asp:Label>
                                <span class="requiredField">*</span>
                            </td>
                            <td style="text-align: left;">
                                <!-- Q7 - Read newspaper or magazine articles -->
                                <asp:RadioButtonList ID="rblQ7" runat="server" RepeatDirection="Horizontal" Width="200px" DataSourceID="ObjectDataSourceQ7"
                                    TabIndex="39" DataTextField="CHOICE_NAME" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave"
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <!--Question 7 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ7" runat="server" ControlToValidate="rblQ7" TabIndex="40" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <!--Question 7 Object Data Source-->
                                <asp:ObjectDataSource ID="ObjectDataSourceQ7" runat="server" 
                                    SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ7" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <!--Question 7 : Question Number-->
                                <asp:HiddenField ID="HiddenQ7" runat="server" Visible="false" Value="7" />
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 20px;">
                                7.
                            </td>
                            <td style="text-align: left;">
                                <!--Question 8: Eat and drink neatly-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ8" runat="server" AssociatedControlID="rblQ8" SkinID="DataLabel" TabIndex="41">
                                </asp:Label>
                                <span class="requiredField">*</span>
                            </td>
                            <td style="text-align: left;">
                                <!-- Q8 - Read newspaper or magazine articles -->
                                <asp:RadioButtonList ID="rblQ8" runat="server" RepeatDirection="Horizontal" Width="200px" DataSourceID="ObjectDataSourceQ8"
                                    TabIndex="42" DataTextField="CHOICE_NAME" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave"
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <!--Question 8 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ8" runat="server" ControlToValidate="rblQ8" TabIndex="43" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <!--Question 8 Object Data Source-->
                                <asp:ObjectDataSource ID="ObjectDataSourceQ8" runat="server" 
                                    SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ8" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <!--Question 8 : Question Number-->
                                <asp:HiddenField ID="HiddenQ8" runat="server" Visible="false" Value="8" />
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 20px;">
                                8.
                            </td>
                            <td style="text-align: left;">
                                <!--Question 9: Prepare meals-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ9" runat="server" AssociatedControlID="rblQ9" SkinID="DataLabel" TabIndex="44">
                                </asp:Label>
                                <span class="requiredField">*</span>
                            </td>
                            <td style="text-align: left;">
                                <!-- Q9 -Prepare meals -->
                                <asp:RadioButtonList ID="rblQ9" runat="server" RepeatDirection="Horizontal" Width="200px" DataSourceID="ObjectDataSourceQ9"
                                    TabIndex="45" DataTextField="CHOICE_NAME" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave"
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <!--Question 9 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ9" runat="server" ControlToValidate="rblQ9" TabIndex="46" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <!--Question 9 Object Data Source-->
                                <asp:ObjectDataSource ID="ObjectDataSourceQ9" runat="server" 
                                    SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ9" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <!--Question 9 : Question Number-->
                                <asp:HiddenField ID="HiddenQ9" runat="server" Visible="false" Value="9" />
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 20px;">
                                9.
                            </td>
                            <td style="text-align: left;">
                                <!--Question 10:Read menus ->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ10" runat="server" AssociatedControlID="rblQ10" SkinID="DataLabel" TabIndex="47">
                                </asp:Label>
                                <span class="requiredField">*</span>
                            </td>
                            <td style="text-align: left;">
                                <!-- Q10 Read menus -->
                                <asp:RadioButtonList ID="rblQ10" runat="server" RepeatDirection="Horizontal" Width="200px" DataSourceID="ObjectDataSourceQ10"
                                    TabIndex="48" DataTextField="CHOICE_NAME" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave"
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <!--Question 10 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ10" runat="server" ControlToValidate="rblQ10" TabIndex="49" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <!--Question 10 Object Data Source-->
                                <asp:ObjectDataSource ID="ObjectDataSourceQ10" runat="server" 
                                    SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ10" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <!--Question 10 : Question Number-->
                                <asp:HiddenField ID="HiddenQ10" runat="server" Visible="false" Value="10" />
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 20px;">
                                10.
                            </td>
                            <td style="text-align: left;">
                                <!--Question 11: Groom yourself -->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ11" runat="server" AssociatedControlID="rblQ11" SkinID="DataLabel" TabIndex="50">
                                </asp:Label>
                                <span class="requiredField">*</span>
                            </td>
                            <td style="text-align: left;">
                                <!-- Q11 Groom yourself-->
                                <asp:RadioButtonList ID="rblQ11" runat="server" RepeatDirection="Horizontal" Width="200px" DataSourceID="ObjectDataSourceQ11"
                                    TabIndex="51" DataTextField="CHOICE_NAME" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave"
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <!--Question 11 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ11" runat="server" ControlToValidate="rblQ11" TabIndex="52" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <!--Question 11 Object Data Source-->
                                <asp:ObjectDataSource ID="ObjectDataSourceQ11" runat="server" 
                                    SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ11" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <!--Question 11 : Question Number-->
                                <asp:HiddenField ID="HiddenQ11" runat="server" Visible="false" Value="11" />
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 20px;">
                                11.
                            </td>
                            <td style="text-align: left;">
                                <!--Question 12: Identify medicine -->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ12" runat="server" AssociatedControlID="rblQ12" SkinID="DataLabel" TabIndex="53">
                                </asp:Label>
                                <span class="requiredField">*</span>
                            </td>
                            <td style="text-align: left;">
                                <!-- Q12 - Identify medicine -->
                                <asp:RadioButtonList ID="rblQ12" runat="server" RepeatDirection="Horizontal" Width="200px" DataSourceID="ObjectDataSourceQ12"
                                    TabIndex="54" DataTextField="CHOICE_NAME" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave"
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <!--Question 12 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ12" runat="server" ControlToValidate="rblQ12" TabIndex="55" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <!--Question 12 Object Data Source-->
                                <asp:ObjectDataSource ID="ObjectDataSourceQ12" runat="server" 
                                    SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ12" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <!--Question 12 : Question Number-->
                                <asp:HiddenField ID="HiddenQ12" runat="server" Visible="false" Value="12" />
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 20px;">
                                12.
                            </td>
                            <td style="text-align: left;">
                                <!--Question 13: Tell time-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ13" runat="server" AssociatedControlID="rblQ13" SkinID="DataLabel" TabIndex="56">
                                </asp:Label>
                                <span class="requiredField">*</span>
                            </td>
                            <td style="text-align: left;">
                                <!-- Q13 -Tell time -->
                                <asp:RadioButtonList ID="rblQ13" runat="server" RepeatDirection="Horizontal" Width="200px" DataSourceID="ObjectDataSourceQ13"
                                    TabIndex="57" DataTextField="CHOICE_NAME" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave"
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <!--Question 13 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ13" runat="server" ControlToValidate="rblQ13" TabIndex="58" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <!--Question 13 Object Data Source-->
                                <asp:ObjectDataSource ID="ObjectDataSourceQ13" runat="server" 
                                    SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ13" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <!--Question 13 : Question Number-->
                                <asp:HiddenField ID="HiddenQ13" runat="server" Visible="false" Value="13" />
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 20px;">
                                13.
                            </td>
                            <td style="text-align: left;">
                                <!--Question 14: Use applicable dials-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ14" runat="server" AssociatedControlID="rblQ14" SkinID="DataLabel" TabIndex="59">
                                </asp:Label>
                                <span class="requiredField">*</span>
                            </td>
                            <td style="text-align: left;">
                                <!-- Q14 - Use applicable dials-->
                                <asp:RadioButtonList ID="rblQ14" runat="server" RepeatDirection="Horizontal" Width="200px" DataSourceID="ObjectDataSourceQ14"
                                    TabIndex="60" DataTextField="CHOICE_NAME" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave"
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <!--Question 14 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ14" runat="server" ControlToValidate="rblQ14" TabIndex="61" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <!--Question 14 Object Data Source-->
                                <asp:ObjectDataSource ID="ObjectDataSourceQ14" runat="server" 
                                    SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ14" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <!--Question 14 : Question Number-->
                                <asp:HiddenField ID="HiddenQ14" runat="server" Visible="false" Value="14" />
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 20px;">
                                14.
                            </td>
                            <td style="text-align: left;">
                                <!--Question 15: Find something on a crowded shelf-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ15" runat="server" AssociatedControlID="rblQ15" SkinID="DataLabel" TabIndex="62">
                                </asp:Label>
                                <span class="requiredField">*</span>
                            </td>
                            <td style="text-align: left;">
                                <!-- Q15 - Find something on a crowded shelf-->
                                <asp:RadioButtonList ID="rblQ15" runat="server" RepeatDirection="Horizontal" Width="200px" DataSourceID="ObjectDataSourceQ15"
                                    TabIndex="63" DataTextField="CHOICE_NAME" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave"
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <!--Question 15 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ15" runat="server" ControlToValidate="rblQ15" TabIndex="64" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <!--Question 15 Object Data Source-->
                                <asp:ObjectDataSource ID="ObjectDataSourceQ15" runat="server" 
                                    SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ15" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <!--Question 15 : Question Number-->
                                <asp:HiddenField ID="HiddenQ15" runat="server" Visible="false" Value="15" />
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 20px;">
                                15.
                            </td>
                            <td style="text-align: left;">
                                <!--Question 16: Watch TV-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ16" runat="server" AssociatedControlID="rblQ16" SkinID="DataLabel" TabIndex="65">
                                </asp:Label>
                                <span class="requiredField">*</span>
                            </td>
                            <td style="text-align: left;">
                                <!-- Q16 - Watch TV-->
                                <asp:RadioButtonList ID="rblQ16" runat="server" RepeatDirection="Horizontal" Width="200px" DataSourceID="ObjectDataSourceQ16"
                                    TabIndex="66" DataTextField="CHOICE_NAME" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave"
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <!--Question 16 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ16" runat="server" ControlToValidate="rblQ16" TabIndex="67" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <!--Question 16 Object Data Source-->
                                <asp:ObjectDataSource ID="ObjectDataSourceQ16" runat="server" 
                                    SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ16" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <!--Question 16 : Question Number-->
                                <asp:HiddenField ID="HiddenQ16" runat="server" Visible="false" Value="16" />
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 20px;">
                                16.
                            </td>
                            <td style="text-align: left;">
                                <!--Question 17: Read print on TV-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ17" runat="server" AssociatedControlID="rblQ17" SkinID="DataLabel" TabIndex="68">
                                </asp:Label>
                                <span class="requiredField">*</span>
                            </td>
                            <td style="text-align: left;">
                                <!-- Q17 - Read print on TV-->
                                <asp:RadioButtonList ID="rblQ17" runat="server" RepeatDirection="Horizontal" Width="200px" DataSourceID="ObjectDataSourceQ17"
                                    TabIndex="69" DataTextField="CHOICE_NAME" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave"
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <!--Question 17 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ17" runat="server" ControlToValidate="rblQ17" TabIndex="70" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <!--Question 17 Object Data Source-->
                                <asp:ObjectDataSource ID="ObjectDataSourceQ17" runat="server" 
                                    SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ17" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <!--Question 17 : Question Number-->
                                <asp:HiddenField ID="HiddenQ17" runat="server" Visible="false" Value="17" />
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 20px;">
                                17.
                            </td>
                            <td style="text-align: left;">
                                <!--Question 18: See photos-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ18" runat="server" AssociatedControlID="rblQ18" SkinID="DataLabel" TabIndex="71">
                                </asp:Label>
                                <span class="requiredField">*</span>
                            </td>
                            <td style="text-align: left;">
                                <!-- Q18 - See photos-->
                                <asp:RadioButtonList ID="rblQ18" runat="server" RepeatDirection="Horizontal" Width="200px" DataSourceID="ObjectDataSourceQ18"
                                    TabIndex="72" DataTextField="CHOICE_NAME" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave"
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <!--Question 18 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ18" runat="server" ControlToValidate="rblQ18" TabIndex="73" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <!--Question 18 Object Data Source-->
                                <asp:ObjectDataSource ID="ObjectDataSourceQ18" runat="server" 
                                    SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ18" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <!--Question 18 : Question Number-->
                                <asp:HiddenField ID="HiddenQ18" runat="server" Visible="false" Value="18" />
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 20px;">
                                18.
                            </td>
                            <td style="text-align: left;">
                                <!--Question 19: Get around outdoors in places you know-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ19" runat="server" AssociatedControlID="rblQ19" SkinID="DataLabel" TabIndex="74">
                                </asp:Label>
                                <span class="requiredField">*</span>
                            </td>
                            <td style="text-align: left;">
                                <!-- Q19 - Get around outdoors in places you know-->
                                <asp:RadioButtonList ID="rblQ19" runat="server" RepeatDirection="Horizontal" Width="200px" DataSourceID="ObjectDataSourceQ19"
                                    TabIndex="75" DataTextField="CHOICE_NAME" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave"
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <!--Question 19 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ19" runat="server" ControlToValidate="rblQ19" TabIndex="76" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <!--Question 19 Object Data Source-->
                                <asp:ObjectDataSource ID="ObjectDataSourceQ19" runat="server" 
                                    SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ19" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <!--Question 19 : Question Number-->
                                <asp:HiddenField ID="HiddenQ19" runat="server" Visible="false" Value="19" />
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 20px;">
                                19.
                            </td>
                            <td style="text-align: left;">
                                <!--Question 20: Read street signs and store names-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ20" runat="server" AssociatedControlID="rblQ20" SkinID="DataLabel" TabIndex="77">
                                </asp:Label>
                                <span class="requiredField">*</span>
                            </td>
                            <td style="text-align: left;">
                                <!-- Q20 - Read street signs and store names-->
                                <asp:RadioButtonList ID="rblQ20" runat="server" RepeatDirection="Horizontal" Width="200px" DataSourceID="ObjectDataSourceQ20"
                                    TabIndex="78" DataTextField="CHOICE_NAME" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave"
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <!--Question 20 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ20" runat="server" ControlToValidate="rblQ20" TabIndex="79" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <!--Question 20 Object Data Source-->
                                <asp:ObjectDataSource ID="ObjectDataSourceQ20" runat="server" 
                                    SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ20" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <!--Question 20 : Question Number-->
                                <asp:HiddenField ID="HiddenQ20" runat="server" Visible="false" Value="20" />
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 20px;">
                                20.
                            </td>
                            <td style="text-align: left;">
                                <!--Question 21: Adjust to bright light-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ21" runat="server" AssociatedControlID="rblQ21" SkinID="DataLabel" TabIndex="80">
                                </asp:Label>
                                <span class="requiredField">*</span>
                            </td>
                            <td style="text-align: left;">
                                <!-- Q21 - Adjust to bright light-->
                                <asp:RadioButtonList ID="rblQ21" runat="server" RepeatDirection="Horizontal" Width="200px" DataSourceID="ObjectDataSourceQ21"
                                    TabIndex="81" DataTextField="CHOICE_NAME" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave"
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <!--Question 21 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ21" runat="server" ControlToValidate="rblQ21" TabIndex="82" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <!--Question 21 Object Data Source-->
                                <asp:ObjectDataSource ID="ObjectDataSourceQ21" runat="server" 
                                    SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ21" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <!--Question 21 : Question Number-->
                                <asp:HiddenField ID="HiddenQ21" runat="server" Visible="false" Value="21" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%" style="font-size:1px; height:5px;">
                            </td>
                        </tr>
                        <asp:Panel ID="pnlBaselineScores" runat="server" Visible="false">
                        <tr>
                            <td style="width: 20px;">
                                
                            </td>
                            <td style="text-align: left;">
                                <!--Question 23: Average Baseline Score-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ22" runat="server" AssociatedControlID="txtQ22" SkinID="DataLabel" TabIndex="83">
                                </asp:Label>
                            </td>
                            <td style="text-align: left;">
                                <!-- Q22 - Average Baseline Score-->
                                <asp:TextBox ID="txtQ22" runat="server" Enabled="false" Width="185px" TabIndex="84" />
                            </td>
                        </tr>
                        </asp:Panel>
                        <asp:Panel ID="pnlFollowupScores" runat="server" Visible="false">
                        <tr>
                            <td style="width: 20px;">
                                
                            </td>
                            <td style="text-align: left;">
                                <!--Question 23: Average Follow-up Score-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ23" runat="server" AssociatedControlID="txtQ23" SkinID="DataLabel" TabIndex="85">
                                </asp:Label>
                            </td>
                            <td style="text-align: left;">
                                <!-- Q23 - Average Baseline Score-->
                                <asp:TextBox ID="txtQ23" runat="server" Enabled="false" Width="185px" TabIndex="86" />
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 20px;">
                                
                            </td>
                            <td style="text-align: left;">
                                <!--Question 24: Overall Change Score-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ24" runat="server" AssociatedControlID="txtQ24" SkinID="DataLabel" TabIndex="87">
                                </asp:Label>
                            </td>
                            <td style="text-align: left;">
                                <!-- Q24 - Overall Change Score-->
                                <asp:TextBox ID="txtQ24" runat="server" Enabled="false" Width="185px" TabIndex="88" />
                            </td>
                        </tr>
                        </asp:Panel>
                    </table>
                    <!-- End Question Area -->
                    <br />
                </asp:Panel>
                <telerik:RadAjaxPanel ID="RadAjaxPanel1" runat="server">
                    <asp:Timer ID="InactiveTimer" Interval="300000" Enabled="true" runat="server" OnTick="InActiveTimer_Tick" />
                </telerik:RadAjaxPanel>
                <asp:Button ID="btnSaveSurveyDraft" runat="server" UseSubmitBehavior="true" Text="Save Draft" Width="130px" OnClick="btnSaveSurveyDraft_Click"
                    ValidationGroup="OnSaveDraft" TabIndex="89" />
                <asp:Button ID="btnSubmitSurvey" runat="server" UseSubmitBehavior="true" Text="Save and Prepare Note" Width="180px" OnClick="btnSubmit_Click"
                    ValidationGroup="OnSave" TabIndex="90" />
                <asp:Button ID="btnCancelSurvey" runat="server" TabIndex="91" UseSubmitBehavior="false" Text="Cancel" Width="130px" OnClick="btnCancel_Click" />
            </ContentTemplate>
        </asp:UpdatePanel>
    </telerik:RadCodeBlock>
</asp:Content>